## 方法一：哈希表

利用数据结构特点，容易想到使用哈希表（Set）记录数组的各个数字，当查找到重复数字则直接返回。

### 算法流程：

1. 初始化： 新建 HashSet ，记为 $hmap$ ；
2. 遍历数组 $documents$ 中的每个数字 $doc$ ：
   1. 当 $doc$ 在 $hmap$ 中，说明重复，直接返回 $doc$ ；
   2. 将 $doc$ 添加至 $hmap$ 中；
3. 返回 $-1$ 。本题中一定有重复数字，因此这里返回多少都可以。

> 下图中的 `nums` 对应本题的 `documents` 。

<![Picture1.png](https://pic.leetcode-cn.com/b73933d9cafbbed2d3b3cc3353f2ef7e9af2614d623c7e87f7bc6d8fbaf27f40-Picture1.png),![Picture2.png](https://pic.leetcode-cn.com/e97aa100bcab08166e04da36bc9f3537d2cde0f7cc4e027e12b4765fd3c0f042-Picture2.png),![Picture3.png](https://pic.leetcode-cn.com/3e40c3d2c2d5b36522d7884c685029720dffb787d4c2dd12b70596d4cedf8120-Picture3.png),![Picture4.png](https://pic.leetcode-cn.com/b5a77688e2c989573786fa7b6b1b30026f9ffe0070d0b1760cf8931573545462-Picture4.png),![Picture5.png](https://pic.leetcode-cn.com/29528f65ea95425b032c3039a8c80d9e2ae4f9cac89eef3a8c19bfc668abb546-Picture5.png),![Picture6.png](https://pic.leetcode-cn.com/23d093dbd8fd248e9075fbee511483adaef103fb072d18eec3a8d3d00c870512-Picture6.png)>

### 代码：

```Python []
class Solution:
    def findRepeatDocument(self, documents: List[int]) -> int:
        hmap = set()
        for doc in documents:
            if doc in hmap: return doc
            hmap.add(doc)
        return -1
```

```Java []
class Solution {
    public int findRepeatDocument(int[] documents) {
        Set<Integer> hmap = new HashSet<>();
        for(int doc : documents) {
            if(hmap.contains(doc)) return doc;
            hmap.add(doc);
        }
        return -1;
    }
}
```

```C++ []
class Solution {
public:
    int findRepeatDocument(vector<int>& documents) {
        unordered_map<int, bool> map;
        for(int doc : documents) {
            if(map[doc]) return doc;
            map[doc] = true;
        }
        return -1;
    }
};
```

### 复杂度分析：

- **时间复杂度 $O(N)$ ：** 遍历数组使用 $O(N)$ ，HashSet 添加与查找元素皆为 $O(1)$ 。
- **空间复杂度 $O(N)$ ：** HashSet 占用 $O(N)$ 大小的额外空间。

## 方法二：原地交换

题目说明尚未被充分使用，即 `在一个长度为 n 的数组 documents 里的所有数字都在 0 ~ n-1 的范围内` 。 此说明含义：数组元素的 **索引** 和 **值** 是 **一对多** 的关系。
因此，可遍历数组并通过交换操作，使元素的 **索引** 与 **值** 一一对应（即 $documents[i] = i$ ）。因而，就能通过索引映射对应的值，起到与字典等价的作用。

![Picture0.png](https://pic.leetcode-cn.com/1618146573-bOieFQ-Picture0.png){:align=center width=500}

遍历中，第一次遇到数字 $x$ 时，将其交换至索引 $x$ 处；而当第二次遇到数字 $x$ 时，一定有 $documents[x] = x$ ，此时即可得到一组重复数字。

### 算法流程：

1. 遍历数组 $documents$ ，设索引初始值为 $i = 0$ :
   1. **若 $documents[i] = i$ ：** 说明此数字已在对应索引位置，无需交换，因此跳过；
   2. **若 $documents[documents[i]] = documents[i]$ ：** 代表索引 $documents[i]$ 处和索引 $i$ 处的元素值都为 $documents[i]$ ，即找到一组重复值，返回此值 $documents[i]$ ；
   3. **否则：** 交换索引为 $i$ 和 $documents[i]$ 的元素值，将此数字交换至对应索引位置。

2. 若遍历完毕尚未返回，则返回 $-1$ 。

<![Picture7.png](https://pic.leetcode-cn.com/45a6303cd3ab50036a99ae89e2b0458f9b4885bb9d089997dfc0e5851a6a6300-Picture7.png),![Picture8.png](https://pic.leetcode-cn.com/58905a586575382e51096a5ce3e9e098ef8df215723174b4ac1d042e10a95c01-Picture8.png),![Picture9.png](https://pic.leetcode-cn.com/68a992b40bd5781a388c4fe811cd7a7c9b8dbb659089ed7473605323df76d241-Picture9.png),![Picture10.png](https://pic.leetcode-cn.com/98fd49b23dbb73cba6c551faaabfaaf5b3bbaed5f50f6c11ac42496bdfd2eba1-Picture10.png),![Picture11.png](https://pic.leetcode-cn.com/e6089e2d686fb1e76feb4f065ed14f7d2c02eadcdbfb6d4e2e9b6843f64914c3-Picture11.png),![Picture12.png](https://pic.leetcode-cn.com/80f2f1df8c43f56d63d09118fcb49c6c9d834aa743b01e9f8fd2b1ac9ce85403-Picture12.png),![Picture13.png](https://pic.leetcode-cn.com/64c97efd298d010e91b89eb18c7eb961538d6c1da400495c328dd92de3b47648-Picture13.png),![Picture14.png](https://pic.leetcode-cn.com/eaf0db1a4b0e0869d29fa789a234888d45dfffc5d1d13c5fb1c237a0b1bc5389-Picture14.png),![Picture15.png](https://pic.leetcode-cn.com/82ea50d1915609e368839cac6d4e0e615ff8297138aff645d0c2aba79e6a7b7e-Picture15.png)>

### 代码：

Python 中，$a, b = c, d$ 操作的原理是先暂存元组 $(c, d)$ ，然后 “按左右顺序” 赋值给 a 和 b 。
因此，若写为 $documents[i], documents[documents[i]] = documents[documents[i]], documents[i]$ ，则 $documents[i]$ 会先被赋值，之后 $documents[documents[i]]$ 指向的元素则会出错。

```Python []
class Solution:
    def findRepeatDocument(self, documents: List[int]) -> int:
        i = 0
        while i < len(documents):
            if documents[i] == i:
                i += 1
                continue
            if documents[documents[i]] == documents[i]: return documents[i]
            documents[documents[i]], documents[i] = documents[i], documents[documents[i]]
        return -1
```

```Java []
class Solution {
    public int findRepeatDocument(int[] documents) {
        int i = 0;
        while(i < documents.length) {
            if(documents[i] == i) {
                i++;
                continue;
            }
            if(documents[documents[i]] == documents[i]) return documents[i];
            int tmp = documents[i];
            documents[i] = documents[tmp];
            documents[tmp] = tmp;
        }
        return -1;
    }
}
```

```C++ []
class Solution {
public:
    int findRepeatDocument(vector<int>& documents) {
        int i = 0;
        while(i < documents.size()) {
            if(documents[i] == i) {
                i++;
                continue;
            }
            if(documents[documents[i]] == documents[i])
                return documents[i];
            swap(documents[i],documents[documents[i]]);
        }
        return -1;
    }
};
```

### 复杂度分析：

- **时间复杂度 $O(N)$ ：** 遍历数组使用 $O(N)$ ，每轮遍历的判断和交换操作使用 $O(1)$ 。
- **空间复杂度 $O(1)$ ：** 使用常数复杂度的额外空间。
